/*

VMPC stream cipher with KSA3.

Ported to ISO C by Alexander Myasnikov.

e-mail: alexanderwdark@ya.ru


*/

typedef unsigned char u8;

u8 n = 0;
u8 P[256];
u8 s = 0;


void __stdcall __export
setup (u8 * key, u8 * iv)
{
  long m, i;
  u8 temp;
  s = 0;

  for (i = 0; i != 256; i++)
    {
      P[i] = (u8) i;
    }

  for (m = 0; m != 768; m++)
    {
      s = P[(s + P[m & 0xff] + key[m % 64]) & 0xff];
      temp = P[m & 0xff];
      P[m & 0xff] = P[s & 0xff];
      P[s & 0xff] = temp;
    }

  for (m = 0; m != 768; m++)
    {
      s = P[(s + P[m & 0xff] + iv[m % 64]) & 0xff];
      temp = P[m & 0xff];
      P[m & 0xff] = P[s & 0xff];
      P[s & 0xff] = temp;
    }

  for (m = 0; m != 768; m++)
    {
      s = P[(s + P[m & 0xff] + key[m % 64]) & 0xff];
      temp = P[m & 0xff];
      P[m & 0xff] = P[s & 0xff];
      P[s & 0xff] = temp;
    }

  n = 0;
}

void __stdcall __export
crypt (u8 * input, u8 * output, long len)
{
  long i;
  u8 z, temp;
  for (i = 0; i != len; i++)
    {
      s = P[(s + P[n & 0xff]) & 0xff];
      z = P[(P[(P[s & 0xff]) & 0xff] + 1) & 0xff];
      temp = P[n & 0xff];
      P[n & 0xff] = P[s & 0xff];
      P[s & 0xff] = temp;
      n = (u8) ((n + 1) & 0xff);
      output[i] = (u8) (input[i] ^ z);
    }
}
